/**
 * Deze klass beschrijft een heel eenvoudige geldautomaat waarin je muntstukken werpt. 
 * Je kan steeds aflezen hoeveel het ingeworpen bedrag is.
 * Je kan al het geld terug uit de automaat halen.
 *
 * @author Dominiek Vandewalle
 * @version 2014-08-17
 */
public class GeldAutomaat1
{
    // velden
    private double bedragInAutomaat;

    /**
     * Constructor voor objecten van de klasse GeldAutomaat.
     */
    public GeldAutomaat1()
    {
        bedragInAutomaat = 0;
    }
    
    /**
     * Toont hoeveel geld in de geldautomaat zit.
     *
     * @return    Geeft het aanwezige bedrag in de automaat weer.
     */
    public double getBedragInAutomaat()
    {
        return bedragInAutomaat;
    }

    /**
     * Werp een zeker bedrag in de geldautomaat.
     *
     * @param  muntstuk    Het bedrag van het muntstuk in euro dat ingeworpen werd.
     */
    public void werpMuntstukInAutomaat(double muntstuk)
    {
        // ingeworpen bedrag bij totale bedrag in automaat tellen.
        bedragInAutomaat = bedragInAutomaat + muntstuk;
    }
    
    /**
     * Geeft al het geld in de geldautomaat terug. Er blijft 0 euro over in de geldautomaat.
     *
     * @return    Geeft het aanwezige bedrag in de automaat terug.
     */
    public double resetAutomaat()
    {
        double hulp;
        hulp = bedragInAutomaat;
        bedragInAutomaat = 0;
        return hulp;
    }
}